<?php if(!empty($customer)): ?>
    <div class="modal-content" id="editCustomer">
    <?php echo e(Form::model($customer, array('route' => array('customers.update', $customer->id), 'method' => 'PUT', 'files' => true))); ?>

<?php else: ?>
    <div class="modal-content" id="addCustomer">
        <?php echo e(Form::open(array('url' => 'customers', 'files' => true,))); ?>

<?php endif; ?>
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4 class="modal-title"><?php if(!empty($customer)): ?> <?php echo e(__('Edit Customer')); ?> <?php else: ?> <?php echo e(__('Add Customer')); ?><?php endif; ?></h4>
    </div>
    <div class="modal-body" >
       <div class="row">
            <div class="col-sm-6">
                <div class="form-group row">
                    <?php echo e(Form::label('name', trans('customer.name') .' *',['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9"> 
                        <?php echo e(Form::text('name', null, array('class' => 'form-control', 'required'))); ?>

                    </div>
                </div>
                <div class="form-group row">
                <?php echo e(Form::label('email', trans('customer.email'),['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9">
                        <?php echo e(Form::text('email', null, array('class' => 'form-control'))); ?>

                    </div>
                </div>
                <div class="form-group row">
                <?php echo e(Form::label('phone_number', __('Phone'), ['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9"> 
                        <?php echo e(Form::text('phone_number', null, array('class' => 'form-control'))); ?>

                    </div>
                </div>
                <div class="form-group row">
                    <?php echo e(Form::label('address', trans('customer.address'),['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9"> 
                        <?php echo e(Form::text('address', null, array('class' => 'form-control'))); ?>

                    </div>
                </div>

                <div class="form-group row">
                    <?php echo e(Form::label('city', trans('customer.city'),['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9"> 
                    <?php echo e(Form::text('city', null, array('class' => 'form-control'))); ?>

                    </div>
                </div>
                
            </div>
            <div class="col-sm-6">
                <div class="form-group row">
                    <?php echo e(Form::label('state', trans('customer.state'),['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9"> 
                        <?php echo e(Form::text('state', null, array('class' => 'form-control'))); ?>

                    </div>
                </div>
                <div class="form-group row">
                    <?php echo e(Form::label('zip', trans('customer.zip'),['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9"> 
                    <?php echo e(Form::text('zip', null, array('class' => 'form-control'))); ?>

                    </div>
                </div>

                <div class="form-group row">
                    <?php echo e(Form::label('prev_balance', __('Balance'), ['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9">
                        <?php if(!empty($customer)): ?>
                            <?php echo e(Form::number('prev_balance', null, ['class' => 'form-control'])); ?>

                            <?php else: ?>
                            <?php echo e(Form::number('prev_balance', 0, ['class' => 'form-control'])); ?>

                        <?php endif; ?>
                    </div>
                </div>

                <div class="form-group row">
                    <?php echo e(Form::label('payment', trans('customer.payment') ,['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9">
                        <?php if(!empty($customer)): ?>
                        <?php echo e(Form::number('payment', null, ['class' => 'form-control', 'readonly'=>''])); ?>

                        <?php else: ?>
                        <?php echo e(Form::number('payment', 0, ['class' => 'form-control'])); ?>

                        <?php endif; ?>
                    </div>
                </div>
                <div class="form-group row">
                    <?php echo e(Form::label('avatar', trans('customer.choose_avatar'),['class'=>'col-sm-3 text-right'])); ?>

                    <div class="col-sm-9">
                    <?php echo e(Form::file('avatar', null, array('class' => 'form-control'))); ?>

                        <?php if(isset($customer->avatar)): ?>
                        <img src="<?php echo e($customer->fileUrl()); ?>" alt="" height="35">
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <?php if(!empty($page)): ?>
        <input type="hidden" name="page" value="<?php echo e($page); ?>" />
        <?php endif; ?>
        <?php echo e(Form::submit(trans('customer.submit'), array('class' => 'btn btn-success'))); ?>

        <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
    </div>
    <?php echo e(Form::close()); ?>

</div><?php /**PATH /Users/ajitdas/prjs-mega/flexiblepos-v2.0/resources/views/customer/form.blade.php ENDPATH**/ ?>