<?php if(!empty($account)): ?>
<div class="modal-content" id="editAccount">
<?php echo e(Form::model($account, array('route' => array('accounts.update', $account->id), 'method' => 'PUT', 'files' => true))); ?>

<?php else: ?>
<div class="modal-content" id="addAccount">
    <?php echo e(Form::open(array('url' => 'accounts', 'files' => true,))); ?>

<?php endif; ?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
    <h4 class="modal-title"><?php if(!empty($account)): ?> <?php echo e(__('Edit Account')); ?> <?php else: ?> <?php echo e(__('Add Account')); ?><?php endif; ?></h4>
</div>
<div class="modal-body" >
    <div class="row">
        <div class="col-md-6" >
            <div class="form-group row">
                <?php echo e(Form::label('name', __('Name') .' *',['class'=>'col-sm-3 text-right'])); ?>

                <div class="col-sm-9">
                    <?php echo e(Form::text('name', null, array('class' => 'form-control', 'required'))); ?>

                </div>
            </div>
            <div class="form-group row">
                <?php echo e(Form::label('company', __('Bank/Company').' *',['class'=>'col-sm-3 text-right'])); ?>

                <div class="col-sm-9">
                    <?php echo e(Form::text('company', null, array('class' => 'form-control', 'required'))); ?>

                </div>
            </div>
            <div class="form-group row">
                <?php echo e(Form::label('branch_name', __('Branch'), ['class'=>'col-sm-3 text-right'])); ?>

                <div class="col-sm-9">
                    <?php echo e(Form::text('branch_name', null, array('class' => 'form-control'))); ?>

                </div>
            </div>
            <div class="form-group row">
                <?php echo e(Form::label('account_no', __('Account No'),['class'=>'col-sm-3 text-right'])); ?>

                <div class="col-sm-9">
                    <?php echo e(Form::number('account_no', null, array('class' => 'form-control'))); ?>

                </div>
            </div>
            
        </div>
        <div class="col-md-6">
            <div class="form-group row">
                <?php echo e(Form::label('email', __('Email'),['class'=>'col-sm-3 text-right'])); ?>

                <div class="col-sm-9">
                    <?php echo e(Form::text('email', null, array('class'=>'form-control'))); ?>

                </div>
            </div>
            <div class="form-group row">
                <?php echo e(Form::label('pin', __('Pin'),['class'=>'col-sm-3 text-right'])); ?>

                <div class="col-sm-9">
                    <?php echo e(Form::number('pin', null, array('class' => 'form-control'))); ?>

                </div>
            </div>
            <div class="form-group row">
                <?php echo e(Form::label('balance', __('Balance').' *',['class'=>'col-sm-3 text-right'])); ?>

                <div class="col-sm-9">
                    <?php echo e(Form::number('balance', null, array('class' => 'form-control', 'required'))); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal-footer">
    <?php echo e(Form::submit(__('Submit'), array('class' => 'btn btn-success'))); ?>

    <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
</div>
<?php echo e(Form::close()); ?>

</div><?php /**PATH /Users/ajitdas/prjs-mega/flexiblepos-v2.0/resources/views/account/form.blade.php ENDPATH**/ ?>