<div class="row" id="editAttributeForm">
    <?php if(!empty($attribute)): ?>
        <?php echo e(Form::model($attribute, array('route' => array('itemattribute.update', $attribute->id), 'method' => 'PUT', 'files' => true))); ?>

    <?php else: ?>
        <?php echo e(Form::open(['url' => route('itemattribute.store'), 'files' => true])); ?>

    <?php endif; ?>
    <?php echo e(Form::hidden('item_id', $item->id, array() )); ?>

      <div class="form-group col-sm-12">
       
        <?php if(!empty($attribute)): ?>
        <h4 class="mb-4">Edit attribute : <?php echo e($attribute->name); ?></h4>
        <?php else: ?>
        <h4 class="mb-4">Create new attribute</h4>
        <?php endif; ?>
      </div>
    <div class="col-sm-6">
        <div class="form-group row">
            <?php echo e(Form::label('name', __('Item'), ['class'=>'col-sm-3 text-right pr-0'])); ?>

            <div class="col-sm-9"> 
            <?php echo e(Form::text('name', $item->item_name, array('class' => 'form-control','required', 'disabled'))); ?>

            </div>
        </div>
      <div class="form-group row">
        <?php echo e(Form::label('name', __('Name'), ['class'=>'col-sm-3 text-right pr-0'])); ?>

        <div class="col-sm-9"> 
        <?php echo e(Form::text('name', null, array('class' => 'form-control','required'))); ?>

        </div>
      </div>
      <div class="form-group row">
        <?php echo e(Form::label('sku', __('SKU'), ['class'=>'col-sm-3 text-right pr-0'])); ?>

        <div class="col-sm-9"> 
        <?php echo e(Form::text('upc_ean_isbn', null, array('class' => 'form-control','required'))); ?>

      </div>
      </div>
      <div class="form-group row">
        <?php echo e(Form::label('cost_price', __('Cost Price'), ['class'=>'col-sm-3 text-right pr-0'])); ?>

        <div class="col-sm-9"> 
        <?php echo e(Form::text('cost_price', null, array('class' => 'form-control','required'))); ?>

        </div>
      </div>
    </div>
    <div class="col-sm-6 pl-0">
      <div class="form-group row">
        <?php echo e(Form::label('selling_price', __('Selling Price'), ['class'=>'col-sm-3 pr-0 text-right'])); ?>

        <div class="col-sm-9"> 
        <?php echo e(Form::text('selling_price', null, array('class' => 'form-control','required'))); ?>

        </div>
      </div>
      <div class="form-group row">
        <?php echo e(Form::label('exp_date', __('Expired Date'), ['class'=>'col-sm-3 pr-0 text-right'])); ?>

        <div class="col-sm-9"> 
        <?php echo e(Form::date('exp_date', null, array('class' => 'form-control','required'))); ?>

        </div>
      </div>
      <div class="form-group row">
        <?php echo e(Form::label('quantity', __('Quantity'), ['class'=>'col-sm-3 pr-0 text-right'])); ?>

        <div class="col-sm-9"> 
        <?php echo e(Form::text('quantity', null, array('class' => 'form-control','required'))); ?>

        </div>
      </div>
      <div class="form-group row">
        <?php echo e(Form::label('image', __('Image:'), ['class'=>'col-sm-3 pr-0 text-right'])); ?>

        <div class="col-sm-9"> 
        <?php echo e(Form::file('image', null, ['class' => 'form-control'])); ?>

        <?php if(!empty($attribute)): ?>
        <img src="<?php echo e($attribute->fileUrl('image')); ?>" alt="" height="35">
        <?php endif; ?>
        </div>
    </div>
    </div>
    <div class="col-sm-12 text-right"> 
        <?php if(!empty($attribute)): ?>
        <?php echo e(Form::submit(__('Update'), ['class' => 'btn btn-success'])); ?>

        <a href="#add" data-ajax-url="<?php echo e(url('itemattribute?item_id='. $item->id)); ?>" class="btn btn-info">Create new </a>
        <?php else: ?>
        <?php echo e(Form::submit(trans('item.submit'), ['class' => 'btn btn-success'])); ?>

        <?php endif; ?>
    </div>
        <?php echo e(Form::close()); ?>

</div><?php /**PATH /Users/ajitdas/prjs-mega/flexiblepos-v2.0/resources/views/item/editAttributeForm.blade.php ENDPATH**/ ?>