<div class="modal-content" id="inventory">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4 class="modal-title"><?php echo e(__('Inventory')); ?></h4>
    </div>
    <div class="modal-body" >
        <div class="box box-success">
            <div class="box-body">
                <table class="table table-bordered">
                    <tr><td><?php echo e(__('UPC/EAN/ISBN')); ?></td><td><?php echo e($item->upc_ean_isbn); ?></td></tr>
                    <tr><td><?php echo e(trans('item.item_name')); ?></td><td><?php echo e($item->item_name); ?></td></tr>
                    <tr><td><?php echo e(trans('item.current_quantity')); ?></td><td><?php echo e($item->quantity); ?></td></tr>
                </table>
                <div class="row" style="padding: 20px 0;">
                    <?php echo e(Form::model($item->inventory, ['route' => ['inventory.update', $item->id], 'method' => 'PUT'])); ?>

                    <div class="col-sm-3 text-right pt-1">
                        <?php echo e(trans('item.inventory_to_add_subtract')); ?> *
                    </div>
                    <div class="col-sm-2">
                        <?php echo e(Form::text('in_out_qty', null, ['class' => 'form-control', 'required'])); ?>

                    </div>
                    <div class="col-sm-1 pt-1">
                        <?php echo e(trans('item.comments')); ?>

                    </div>
                    <div class="col-sm-4">
                        <?php echo e(Form::text('remarks', null, ['class' => 'form-control', 'required'])); ?>

                    </div>
                    <div class="col-sm-1"> 
                        <?php echo e(Form::submit(trans('item.submit'), ['class' => 'btn btn-success'])); ?>

                    </div>
                        <?php echo e(Form::close()); ?>

                </div>
            </div>
            <!-- /.box-body -->
        </div>
        <!-- /.box -->
        <?php echo $__env->make('inventory.partials.inventory_table', ['inventory'=>$sal_inv, 'title'=>'Sale Inventory'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('inventory.partials.inventory_table', ['inventory'=>$rec_inv, 'title'=>'Receive Inventory'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('inventory.partials.inventory_table', ['inventory'=>$other_inv, 'title'=>'Other Inventory'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>    
</div><?php /**PATH /Users/ajitdas/prjs-mega/flexiblepos-v2.0/resources/views/item/inventory.blade.php ENDPATH**/ ?>