
<?php $__env->startSection('page-style'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/pages/dashboard.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<div class="content-wrapper">
		<div class="row">
			<div class="col-md-12">
				<div class="panel-heading">
					<?php echo $__env->make('partials.flash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					<h1><?php echo e(__('Dashboards')); ?> <small><?php echo e(trans('dashboard.statistics')); ?></small></h1>
				</div>
				<div class="panel-body">
					<?php if(auth()->user()->checkSpPermission('Sale-receive-chart Dashboard')): ?>
					<div class="box box-success">
						<div class="box-header with-border">
							<h4><?php echo e(__('Sale & Receive Flow')); ?></h4>
						</div>
						<div class="box-body">
								<div id="area-chart" ></div>
							<input type="hidden" id="chartData" value="<?php echo e(json_encode($incomeexpensechart)); ?>">
						</div>
					</div>
					<?php endif; ?>
					<!-- latest section -->
					<?php if(auth()->user()->checkSpPermission('Latest-income-expense Dashboard')): ?>
					<?php echo $__env->make('dashboard.partials.latest', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					<?php endif; ?>
					<div class="row">
						<div class="col-md-4">
							<div class="purple well">
								<i class="fa fa-user" aria-hidden="true"></i><br>
								<span><?php echo e(trans('dashboard.total_employees')); ?> : <?php echo e($employees); ?></span>
							</div>
						</div>
						<div class="col-md-4">
							<div class="chocolate well">
								<i class="fa fa-users" aria-hidden="true"></i><br>
								<span><?php echo e(trans('dashboard.total_customers')); ?> : <?php echo e($customers); ?></span>
							</div>
						</div>
						<div class="col-md-4">
							<div class="well yellow">
								<i class="fa fa-cubes" aria-hidden="true"></i><br>
								<span><?php echo e(trans('dashboard.total_suppliers')); ?> : <?php echo e($suppliers); ?></span>
							</div>
						</div>
					</div>

					<div class="row">
					  <div class="col-md-3">
						<div class="well green">
							<i class="fa fa-bars" aria-hidden="true"></i><br>
							<span><?php echo e(trans('dashboard.total_items')); ?> : <?php echo e($items); ?></span>
						</div>
					  </div>
					  <div class="col-md-3">
						<div class="well blue">
							<i class="fa fa-list" aria-hidden="true"></i><br>
							<span><?php echo e(trans('dashboard.total_expenses')); ?> : <?php echo e($expenses); ?></span>
						</div>
					  </div>
					  <div class="col-md-3">
						<div class="violet well">
							<i class="fa fa-sitemap" aria-hidden="true"></i><br>
							<span><?php echo e(trans('dashboard.total_receivings')); ?> : <?php echo e($receivings); ?></span>
						</div>
					  </div>
					  <div class="col-md-3">
						<div class="brown well">
							<i class="fa fa-shopping-cart" aria-hidden="true"></i><br>
							<span><?php echo e(trans('dashboard.total_sales')); ?> : <?php echo e($sales); ?></span>
						</div>
					  </div>
					</div>

				</div>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/raphael/2.1.2/raphael-min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.0/morris.min.js"></script>
<script src="<?php echo e(asset('js/dashboard.js')); ?>"></script>
<script>
	$(function () {
		$('[data-toggle="tooltip"]').tooltip()
	});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/ajitdas/prjs-mega/flexiblepos-v2.0/resources/views/home.blade.php ENDPATH**/ ?>