<div id="receivingTable">
 <?php if(count($receivingreport)): ?>
 <table class="table table-striped table-bordered table-hover" id="myTable1">
     <thead>
     <tr>
       
       <th><?php echo e(trans('report-receiving.date')); ?></th>
       <th><?php echo e(__('Items')); ?></th>
       <th class="hidden-xs hidden-sm"><?php echo e(trans('report-receiving.received_by')); ?></th>
       <?php if( $type != 'supplier'): ?>
       <th class="hidden-xs hidden-sm"><?php echo e(trans('report-receiving.supplied_by')); ?></th>
       <?php endif; ?>
       <th class="hidden-xs"><?php echo e(trans('report-receiving.total')); ?></th>
       <th class="hidden-xs"><?php echo e(trans('report-receiving.payment_type')); ?></th>
       <th><?php echo e(trans('report-receiving.payment')); ?></th>
       <th><?php echo e(trans('report-receiving.dues')); ?></th>
       <th><?php echo e(__('Status')); ?></th>
       <th width="50" class="hidden-print">&nbsp;</th>
     </tr>
     </thead>

     <tbody class="list-sale-report">

     <?php $__currentLoopData = $receivingreport; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            
            <td><?php echo e($value->created_at->format('M d, Y')); ?></td>
            <td><?php echo e(count($value->receivingItems)); ?></td>
            <td class="hidden-xs hidden-sm"><?php echo e($value->user->name); ?></td>
            <?php if( $type != 'supplier'): ?>
            <td class="hidden-xs hidden-sm"><?php echo e(!empty($value->supplier->company_name) ? $value->supplier->company_name : ""); ?></td>
            <?php endif; ?>
            <td class="hidden-xs"><?php echo e(currencySymbol().number_format($value->receivingItems->sum('total_cost'), 2)); ?></td>
            <td class="hidden-xs"><?php echo e($value->payment_type); ?></td>
            <td><?php echo e(currencySymbol().$value->payment); ?></td>
            <td><?php echo e(currencySymbol().$value->dues); ?></td>
            <td><?php echo $value->getStatus(); ?></td>
            <td class="hidden-print">
                <div class="btn-group action-btn-group">
                    <button type="button" class="btn action-btn dropdown-toggle" data-toggle="dropdown">
                      <i class="fa fa-cog"></i>
                      <span class="sr-only">Toggle Dropdown</span>
                    </button>
                    <ul class="dropdown-menu" role="menu">
                      <li><a data-toggle="collapse" href="#detailedReports<?php echo e($value->id); ?>" aria-expanded="false" aria-controls="detailedReceivings"><i class="fa fa-list"></i>  <?php echo e(trans('report-sale.detail')); ?></a></li>
                      <?php if(auth()->user()->checkSpPermission('receivings.show-invoice')): ?>
                      <li><a href="<?php echo e(route('receivings.show-invoice', $value->id)); ?>" target="_blank" ><i class="fa fa-file-text-o"></i> <?php echo e(__('Show Invoice')); ?></a></li>
                      <?php endif; ?>
                      <?php if($value->dues > 0 || $type == 'dues'): ?>
                      <li><a href="#" data-toggle="modal" data-target="#myModal<?php echo e($value->id); ?>"><i class="fa fa-money"></i>  <?php echo e(__('Payment')); ?></a></li>
                      <?php endif; ?>
                      
                    </ul>
                    <div class="modal fade" id="myModal<?php echo e($value->id); ?>" role="dialog">
                      <div class="modal-dialog modal-sm">
                          <div class="modal-content">
                            <div class="modal-header">
                              <button type="button" class="close" data-dismiss="modal">&times;</button>
                              <h4 class="modal-title"><?php echo e(__('Add Payment')); ?></h4>
                            </div>
                            <div class="modal-body">
                              <?php echo e(Form::open(['route'=>'receivingpayments.store'])); ?>

                              <div class="form-group">
                                <?php echo e(Form::select('payment_type', $payment_types, null, array('class' => 'form-control','placeholder'=>'Select a payment type','required'))); ?>

                              </div>
                              <div class="form-group"><!---select account input-->
                                <?php echo e(Form::select('account_id', $accounts, null, ['class'=>'form-control', 'placeholder'=>'Select Account', 'required'])); ?>

                              </div>
                              <div class="form-group">
                                <?php echo e(Form::hidden('receiving_id', $value->id, ['class'=>'form-control'])); ?>

                                <?php echo e(Form::number('payment', null, ['class'=>'form-control', 'min'=>0, 'placeholder'=>'Amount', 'required'])); ?>

                              </div>
                              <div class="form-group">
                                <?php echo e(Form::text('comments', null, ['class'=>'form-control','placeholder'=>'Comments'])); ?>

                              </div>
                              <div class="form-group">
                                <?php if($type == 'supplier'): ?>
                                <input type="hidden" name="action_page" value="supplier">
                                <?php echo e(Form::submit('Add Payment', ['class'=>'btn btn-success','onclick'=>"$('.modal-backdrop').remove();"])); ?>

                                <?php else: ?>
                                <input type="hidden" name="action_page" value="receiving_list">
                                <?php echo e(Form::submit('Add Payment', ['class'=>'btn btn-success', 'onclick'=>"$('.modal-backdrop').remove();$('body').removeClass('modal-open');"])); ?>

                                <?php endif; ?>
                                
                              </div>
                              <?php echo e(Form::close()); ?>

                            </div>
                            <div class="modal-footer">
                              <button type="button" class="btn btn-success" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                            </div>
                          </div>
                      </div>
                    </div>
                </div>
            </td>
        </tr>
        <tr class="collapse" id="detailedReports<?php echo e($value->id); ?>">
          <td colspan="9">
            <table class="table">
              <tr>
                  <td><?php echo e(trans('report-receiving.item_id')); ?></td>
                  <td><?php echo e(trans('report-receiving.item_name')); ?></td>
                  <td><?php echo e(trans('report-receiving.item_received')); ?></td>
                  <td><?php echo e(trans('report-receiving.total')); ?></td>
              </tr>
              <?php $__currentLoopData = $value->receivingItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $receiving_detailed): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($receiving_detailed->item_id); ?></td>
                <td><?php echo e($receiving_detailed->item->item_name); ?></td>
                <td><?php echo e($receiving_detailed->quantity); ?></td>
                <td><?php echo e(currencySymbol().$receiving_detailed->quantity * $receiving_detailed->cost_price); ?></td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </table>
          </td>
      </tr>
     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

     </tbody>
 </table>

<?php if($type == 'supplier') { 
  $index_route = route('suppliers.show', $supplier->id);
} else {
  $index_route = url('/receivings');
} ?>
<?php echo $__env->make('partials.pagination', ['items'=>$receivingreport, 'index_route'=>$index_route], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>
</div>
<?php /**PATH /Users/ajitdas/prjs-mega/flexiblepos-v2.0/resources/views/supplier/partials/receiving_table.blade.php ENDPATH**/ ?>