<div class="row">
    <?php if(!empty($stock_limit_items)): ?>
    <div class="col-md-12">
        <div class="box box-success">
            <div class="box-header with-border">
                <h4><?php echo e(__('Stock Alert')); ?></h4>
            </div>
            <div class="box-body">
                <?php echo $__env->make('dashboard.partials.stock_table', ['stock_limit_items'=>$stock_limit_items], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <div class="col-md-4">
        <div class="box box-success single-latest">
            <div class="box-header with-border">
                <h4><?php echo e(__('Latest Incomes')); ?></h4>
            </div>
            <div class="box-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th><?php echo e(__('Date')); ?></th>
                            <th><?php echo e(__('Total')); ?></th>
                            <th><?php echo e(__('Payment')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $latest_incomes->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(date('d M Y', strtotime($item->created_at))); ?></td>
                            <td><?php echo e(currencySymbol().$item->grand_total); ?></td>
                            <td><?php echo e(currencySymbol().$item->payment); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="box box-success single-latest">
            <div class="box-header with-border">
                <h4><?php echo e(__('Latest Expenses')); ?></h4>
            </div>
            <div class="box-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th><?php echo e(__('Date')); ?></th>
                            <th><?php echo e(__('Category')); ?></th>
                            <th><?php echo e(__('Total')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $aexpenses->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(date('d M Y', strtotime($item->created_at))); ?></td>
                            <td><?php echo e($item->expense_category->name); ?></td>
                            <td><?php echo e(currencySymbol().$item->total); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="box box-success single-latest">
            <div class="box-header with-border">
                <h4><?php echo e(__('Account Balance')); ?></h4>
            </div>
            <div class="box-body">
                <table class="table table-striped">
                    <tbody>
                        <?php $__currentLoopData = $accounts->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($item->company); ?></td>
                            <td><?php echo e(currencySymbol().$item->balance); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div><?php /**PATH /Users/ajitdas/prjs-mega/flexibleps-5.6/resources/views/dashboard/partials/latest.blade.php ENDPATH**/ ?>