<div id="saleTable">
<?php if(count($salereport)): ?>
<table class="table table-hover table-striped table-bordered">
  <thead>
    <tr>
      <th><?php echo e(trans('report-sale.date')); ?></th>
      <th><?php echo e(trans('report-sale.items_purchased')); ?></th>
      <th class="hidden-xs"><?php echo e(trans('report-sale.sold_by')); ?></th>
      <?php if( $type != 'customer'): ?>
      <th class="hidden-xs"><?php echo e(trans('report-sale.sold_to')); ?></th>
      <?php endif; ?>
      <th><?php echo e(trans('report-sale.total')); ?></th>
      <th class="hidden-xs"><?php echo e(trans('report-sale.payment')); ?></th>
      <th class="hidden-xs"><?php echo e(trans('report-sale.dues')); ?></th>
      <th class="hidden-xs"><?php echo e(trans('report-sale.payment_type')); ?></th>
      <th><?php echo e(__('Status')); ?></th>
      <th width="60" class="hidden-print">&nbsp;</th>
    </tr>
  </thead>

  <tbody class="list-sale-report">
     <?php $__currentLoopData = $salereport; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr>
      <td><?php echo e($value->created_at->format('d M Y')); ?></td>
      <td><?php echo e(count($value->saleItems)); ?></td>
      <td class="hidden-xs"><?php echo e($value->user->name); ?></td>
      <?php if($type != 'customer'): ?>
      <td class="hidden-xs"><?php echo e(!empty($value->customer) ? $value->customer->name : ''); ?></td>
      <?php endif; ?>
      <td><?php echo e(currencySymbol().$value->grand_total); ?></td>
      <td class="hidden-xs"><?php echo e(currencySymbol().$value->payment); ?> </td>
      <td class="hidden-xs"><?php echo e(currencySymbol().$value->dues); ?></td>
      <td class="hidden-xs"><?php echo e($value->payment_type); ?></td>
      <td><?php echo $value->getStatus(); ?></td>
      <td class="hidden-print">
        <div class="btn-group action-btn-group">
          <button type="button" class="btn action-btn dropdown-toggle" data-toggle="dropdown">
            <i class="fa fa-cog"></i><span class="sr-only">Toggle Dropdown</span>
          </button>
          <ul class="dropdown-menu" role="menu">
              <li><a data-toggle="collapse" href="#detailedSales<?php echo e($value->id); ?>" aria-expanded="false" aria-controls="detailedReceivings"><i class="fa fa-eye"></i> <?php echo e(trans('report-sale.detail')); ?></a></li>
              <?php if(auth()->user()->checkSpPermission('sale.refund')): ?>
              <li><a href="<?php echo e(route('sale.refund', $value->id)); ?>" target="_blank"><i class="fa fa-undo" aria-hidden="true"></i><?php echo e(__('Refund')); ?></a></li>
              <?php endif; ?>
              <?php if(auth()->user()->checkSpPermission('sale.edit')): ?>
              <li><a href="<?php echo e(route('sale.edit', $value->id)); ?>" target="_blank"><i class="fa fa-pencil"></i> <?php echo e(__('Edit')); ?></a></li>
              <?php endif; ?>
              <?php if(auth()->user()->checkSpPermission('sale.show-invoice')): ?>
              <li><a href="<?php echo e(route('sale.show-invoice', $value->id)); ?>" target="_blank" ><i class="fa fa-file-text-o"></i> <?php echo e(__('Show Invoice')); ?></a></li>
              <?php endif; ?>
              <?php if($value->status == \App\Sale::DUE): ?>
              <li><a href="#" data-toggle="modal" data-target="#paymentModal<?php echo e($value->id); ?>" ><i class="fa fa-money"></i>  <?php echo e(__('Payment')); ?></a></li>
              <?php endif; ?>
          </ul>
          <div class="modal submodal fade" id="paymentModal<?php echo e($value->id); ?>" role="dialog">
            <div class="modal-dialog modal-sm">
              <div class="modal-content text-left">
                <div class="modal-header">
                  <button type="button" class="close" onclick="closeEl('.submodal', '#paymentModal<?php echo e($value->id); ?>')">&times;</button>
                  <h4 class="modal-title"><?php echo e(__('Add Payment')); ?></h4>
                </div>
                <div class="modal-body">
                  <?php echo e(Form::open(['route'=>'salepayments.store'])); ?>

                  <div class="form-group">
                    <?php echo e(Form::select('payment_type', $payment_types, null, array('class' => 'form-control','placeholder'=>'Select a payment type','required'))); ?>

                  </div>
                  <div class="form-group"><!---select account input-->
                    <?php echo e(Form::select('account_id', $accounts, null, ['class'=>'form-control', 'placeholder'=>'Select Account', 'required'])); ?>

                  </div>
                  <div class="form-group">
                    <?php echo e(Form::hidden('sale_id', $value->id, ['class'=>'form-control'])); ?>

                    <?php echo e(Form::number('payment', null, ['class'=>'form-control', 'placeholder'=>'Amount', 'min'=>0, 'required'])); ?>

                  </div>
                <div class="form-group">
                    <?php echo e(Form::text('comments', null, ['class'=>'form-control','placeholder'=>'Comments'])); ?>

                </div>
                  <div class="form-group">
                    <?php if($type == 'customer'): ?>
                    <input type="hidden" name="action_page" value="customer">
                    <?php echo e(Form::submit('Add Payment', ['class'=>'btn btn-success','onclick'=>"$('.modal-backdrop').remove();"])); ?>

                    <?php else: ?>
                    <input type="hidden" name="action_page" value="sale_list">
                    <?php echo e(Form::submit('Add Payment', ['class'=>'btn btn-success', 'onclick'=>"$('.modal-backdrop').remove();$('body').removeClass('modal-open');"])); ?>

                    <?php endif; ?>
                  </div>
                  <?php echo e(Form::close()); ?>

                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-success"  onclick="closeEl('.submodal', '#paymentModal<?php echo e($value->id); ?>')"><?php echo e(__('Close')); ?></button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </td>
    </tr>

    <tr class="collapse" id="detailedSales<?php echo e($value->id); ?>">
      <td colspan="10">
          <table class="table">
              <tr>
                  <td><?php echo e(trans('report-sale.item_id')); ?></td>
                  <td><?php echo e(trans('report-sale.item_name')); ?></td>
                  <td><?php echo e(trans('report-sale.quantity_purchase')); ?></td>
                  <td><?php echo e(trans('report-sale.total')); ?></td>
                  <td><?php echo e(trans('report-sale.profit')); ?></td>
              </tr>
              <?php $__currentLoopData = $value->saleItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $SaleDetailed): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                      <td><?php echo e($SaleDetailed->item_id); ?></td>
                      <td><?php echo e($SaleDetailed->item->item_name); ?></td>
                      <td><?php echo e($SaleDetailed->quantity); ?></td>
                      <td><?php echo e(currencySymbol()); ?><?php echo e($SaleDetailed->selling_price * $SaleDetailed->quantity); ?></td>
                      <td><?php echo e(currencySymbol()); ?><?php echo e(($SaleDetailed->quantity * $SaleDetailed->selling_price) - ($SaleDetailed->quantity * $SaleDetailed->cost_price)); ?></td>
                  </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </table>
      </td>
    </tr>
   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </tbody>
</table>

<!-- /.post -->
<?php if($type != 'datefilter'): ?>
<?php if($type == 'customer') { 
  $index_route = route('customers.show', $customer->id);
} else {
  $index_route = url('/sales');
} ?>
<?php echo $__env->make('partials.pagination', ['items'=>$salereport, 'index_route'=>$index_route], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>
<?php endif; ?>
</div><?php /**PATH /Users/ajitdas/prjs-mega/flexiblepos-v2.0/resources/views/customer/partials/sale_table.blade.php ENDPATH**/ ?>