<header class="main-header">
    <!-- Logo -->
    <a href="/" class="logo">
      <!-- mini logo for sidebar mini 50x50 pixels -->
      <span class="logo-mini">
        <?php if(!empty(setting('fevicon_path'))): ?>
        <img src="<?php echo e(asset(\Storage::url(setting('fevicon_path')))); ?>" alt="" height="40px" width="40px">
        <?php else: ?>
        <img src="<?php echo e(asset('images/fevicon.png')); ?>" alt="" height="40px" width="40px">
        <?php endif; ?>

      </span>
      <!-- logo for regular state and mobile devices -->
      <span class="logo-lg">
          <?php if(!empty(setting('logo_path'))): ?>
        <img src="<?php echo e(asset(\Storage::url(setting('logo_path')))); ?>" alt="" height="40px">
        <?php else: ?>
        <img src="<?php echo e(asset('images/fpos.png')); ?>" alt="" height="40px">
        <?php endif; ?>        
        </span>

    </a>
    <!-- Header Navbar: style can be found in header.less -->
    <nav class="navbar navbar-static-top">
      <!-- Sidebar toggle button-->
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">Toggle navigation</span>
      </a>

       <a href="#" class="dropdown-toggle sidebar-toggle quick-icon" role="button" data-toggle="dropdown" id="menu1">
            <i class="fa fa-plus"></i>
        </a>
        <ul class="dropdown-menu quick-dropdown" role="menu" aria-labelledby="menu1">
          <?php if(auth()->user()->checkSpPermission('sales.create')): ?>
          <li role="presentation">
            <a role="menuitem" tabindex="-1" href="<?php echo e(url('sales/create')); ?>"><i class="fa fa-shopping-cart"></i> <?php echo e(__('Sale/Invoice')); ?></a>
          </li>
          <?php endif; ?>
          <?php if(auth()->user()->checkSpPermission('items.create')): ?>
          <li role="presentation"><a role="menuitem" tabindex="-1" href="<?php echo e(route('items.index')); ?>"><i class="fa fa-product-hunt" aria-hidden="true"></i> <?php echo e(__('Items')); ?></a></li>
          <?php endif; ?>
          <?php if(auth()->user()->checkSpPermission('expense.create')): ?>
          <li role="presentation"><a role="menuitem" tabindex="-1" href="<?php echo e(route('expense.index')); ?>"><i class="fa fa-credit-card" aria-hidden="true"></i> <?php echo e(__('Expenses')); ?></a></li>
          <?php endif; ?>
          <?php if(auth()->user()->checkSpPermission('customers.create')): ?>
          <li role="presentation"><a role="menuitem" tabindex="-1" href="<?php echo e(route('customers.index')); ?>"><i class="fa fa-user-plus" aria-hidden="true"></i> <?php echo e(__('Customers')); ?></a></li>
          <?php endif; ?>
          
        </ul>
      
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <!-- User Account: style can be found in dropdown.less -->
          <?php if(Auth::guest()): ?>
			<li><a href="<?php echo e(url('/login')); ?>"><?php echo e(__('Login')); ?></a></li>
    <?php else: ?>
        <?php if(auth()->user()->checkSpPermission('sales.create')): ?>
          <li class="<?php echo e((Request::is('sales/create')) ? 'active' : ''); ?>">
              <a href="<?php echo e(url('sales/create')); ?>"><strong><i class="fa fa-file-text-o"></i> <?php echo e(__('POS/Create Sale/Invoice')); ?></strong></a>
          </li>
        <?php endif; ?>
          <li class="dropdown user user-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
              <img src="<?php echo e(Auth::user()->fileUrl('avatar')); ?>" class="user-image" alt="User Image">
              <span class="hidden-xs"><?php echo e(Auth::user()->name); ?></span>
            </a>
            <ul class="dropdown-menu">
              <!-- User image -->
              <li class="user-header">
                <img src="<?php echo e(Auth::user()->fileUrl('avatar')); ?>" class="img-circle" alt="User Image">
                <p>
                  <?php echo e(Auth::user()->name); ?>

                  <small><?php echo e(__('Member since')); ?> <?php echo e(Auth::user()->created_at->format('Y-m-d')); ?></small>
                </p>
              </li>
              <!-- Menu Body -->
              <li class="user-body">
                <div class="row">
                  <div class="col-xs-6 text-center">
                    <?php if(Auth::user()->checkSpPermission('flexiblepossetting.create')): ?>
                    <a href="<?php echo e(route('flexiblepossetting.create')); ?>"><?php echo e(__('Settings')); ?></a>
                    <?php endif; ?>
                  </div>
                  <div class="col-xs-6 text-center">
                    <?php if(Auth::user()->checkSpPermission('flexiblepossetting.create')): ?>
                    <a href="<?php echo e(route('permissions.list')); ?>"><?php echo e(__('Permissions')); ?></a>
                    <?php endif; ?>
                  </div>
                </div>
                <!-- /.row -->
              </li>
              <!-- Menu Footer-->
              <li class="user-footer">
                <div class="pull-left">
                <a data-replace='#editEmployee' href="#editEmployeeModal" data-ajax-url="<?php echo e(route('employees.edit', Auth::user()->id)); ?>" data-toggle="modal" class="btn btn-info"><?php echo e(__('Profile')); ?></a>
                </div>
                <div class="pull-right">
                  <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();document.getElementById('logout-form').submit();" class="btn btn-warning"><?php echo e(trans('menu.logout')); ?></a>
                  <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                      <?php echo e(csrf_field()); ?>

                  </form>
                </div>
              </li>
            </ul>
          </li>
          <?php endif; ?>
        </ul>
      </div>
    </nav>
  </header>
  <?php echo $__env->make('partials.buy_now_text', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <div class="modal fade sub-modal" id="editEmployeeModal">
    <div class="modal-dialog modal-lg">
        <div class="modal-content" id="editEmployee"></div>
    </div>
  </div><?php /**PATH /Users/ajitdas/prjs-mega/flexiblepos-v2.0/resources/views/partials/navbar.blade.php ENDPATH**/ ?>